/*
 * Decompiled with CFR 0.152.
 */
package org.python.compiler;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Stack;
import org.python.antlr.PythonTree;
import org.python.antlr.Visitor;
import org.python.antlr.ast.ClassDef;
import org.python.antlr.ast.Exec;
import org.python.antlr.ast.Expression;
import org.python.antlr.ast.FunctionDef;
import org.python.antlr.ast.GeneratorExp;
import org.python.antlr.ast.Global;
import org.python.antlr.ast.Import;
import org.python.antlr.ast.ImportFrom;
import org.python.antlr.ast.Interactive;
import org.python.antlr.ast.Lambda;
import org.python.antlr.ast.ListComp;
import org.python.antlr.ast.Module;
import org.python.antlr.ast.Name;
import org.python.antlr.ast.Return;
import org.python.antlr.ast.With;
import org.python.antlr.ast.Yield;
import org.python.antlr.ast.arguments;
import org.python.antlr.ast.expr_contextType;
import org.python.antlr.base.expr;
import org.python.antlr.base.stmt;
import org.python.compiler.ArgListCompiler;
import org.python.compiler.CompilationContext;
import org.python.compiler.Future;
import org.python.compiler.ScopeConstants;
import org.python.compiler.ScopeInfo;
import org.python.core.ParserFacade;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScopesCompiler
extends Visitor
implements ScopeConstants {
    private CompilationContext code_compiler;
    private Stack<ScopeInfo> scopes;
    private ScopeInfo cur = null;
    private Hashtable<PythonTree, ScopeInfo> nodeScopes;
    private int level = 0;
    private int func_level = 0;

    public ScopesCompiler(CompilationContext compilationContext, Hashtable<PythonTree, ScopeInfo> hashtable) {
        this.code_compiler = compilationContext;
        this.nodeScopes = hashtable;
        this.scopes = new Stack();
    }

    public void beginScope(String string, int n, PythonTree pythonTree, ArgListCompiler argListCompiler) {
        if (this.cur != null) {
            this.scopes.push(this.cur);
        }
        if (n == 1) {
            ++this.func_level;
        }
        this.cur = new ScopeInfo(string, pythonTree, this.level++, n, this.func_level, argListCompiler);
        this.nodeScopes.put(pythonTree, this.cur);
    }

    public void endScope() throws Exception {
        if (this.cur.kind == 1) {
            --this.func_level;
        }
        --this.level;
        ScopeInfo scopeInfo = null;
        if (!this.scopes.empty()) {
            scopeInfo = this.scopes.pop();
        }
        int n = 1;
        ScopeInfo scopeInfo2 = scopeInfo;
        int n2 = this.scopes.size() - 1;
        while (n2 >= 0 && scopeInfo2.kind == 2) {
            scopeInfo2 = (ScopeInfo)this.scopes.get(n2);
            --n2;
            ++n;
        }
        this.cur.cook(scopeInfo2, n, this.code_compiler);
        this.cur.dump();
        this.cur = scopeInfo;
    }

    public void parse(PythonTree pythonTree) throws Exception {
        try {
            this.visit(pythonTree);
        }
        catch (Throwable throwable) {
            throw ParserFacade.fixParseError(null, throwable, this.code_compiler.getFilename());
        }
    }

    @Override
    public Object visitInteractive(Interactive interactive) throws Exception {
        this.beginScope("<single-top>", 0, interactive, null);
        this.suite(interactive.getInternalBody());
        this.endScope();
        return null;
    }

    @Override
    public Object visitModule(Module module) throws Exception {
        this.beginScope("<file-top>", 0, module, null);
        this.suite(module.getInternalBody());
        this.endScope();
        return null;
    }

    @Override
    public Object visitExpression(Expression expression) throws Exception {
        this.beginScope("<eval-top>", 0, expression, null);
        this.visit(new Return(expression, expression.getInternalBody()));
        this.endScope();
        return null;
    }

    private void def(String string) {
        this.cur.addBound(string);
    }

    @Override
    public Object visitFunctionDef(FunctionDef functionDef) throws Exception {
        int n;
        int n2;
        this.def(functionDef.getInternalName());
        ArgListCompiler argListCompiler = new ArgListCompiler();
        argListCompiler.visitArgs(functionDef.getInternalArgs());
        List<expr> list = argListCompiler.getDefaults();
        for (int i = 0; i < list.size(); ++i) {
            this.visit(list.get(i));
        }
        List<expr> list2 = functionDef.getInternalDecorator_list();
        for (n2 = list2.size() - 1; n2 >= 0; --n2) {
            this.visit(list2.get(n2));
        }
        this.beginScope(functionDef.getInternalName(), 1, functionDef, argListCompiler);
        n2 = argListCompiler.names.size();
        for (n = 0; n < n2; ++n) {
            this.cur.addParam(argListCompiler.names.get(n));
        }
        for (n = 0; n < argListCompiler.init_code.size(); ++n) {
            this.visit(argListCompiler.init_code.get(n));
        }
        this.cur.markFromParam();
        this.suite(functionDef.getInternalBody());
        this.endScope();
        return null;
    }

    @Override
    public Object visitLambda(Lambda lambda) throws Exception {
        ArgListCompiler argListCompiler = new ArgListCompiler();
        argListCompiler.visitArgs(lambda.getInternalArgs());
        List<expr> list = argListCompiler.getDefaults();
        for (int i = 0; i < list.size(); ++i) {
            this.visit(list.get(i));
        }
        this.beginScope("<lambda>", 1, lambda, argListCompiler);
        for (String object : argListCompiler.names) {
            this.cur.addParam(object);
        }
        for (stmt stmt2 : argListCompiler.init_code) {
            this.visit(stmt2);
        }
        this.cur.markFromParam();
        this.visit(lambda.getInternalBody());
        this.endScope();
        return null;
    }

    public void suite(List<stmt> list) throws Exception {
        for (int i = 0; i < list.size(); ++i) {
            this.visit(list.get(i));
        }
    }

    @Override
    public Object visitImport(Import import_) throws Exception {
        for (int i = 0; i < import_.getInternalNames().size(); ++i) {
            if (import_.getInternalNames().get(i).getInternalAsname() != null) {
                this.cur.addBound(import_.getInternalNames().get(i).getInternalAsname());
                continue;
            }
            String string = import_.getInternalNames().get(i).getInternalName();
            if (string.indexOf(46) > 0) {
                string = string.substring(0, string.indexOf(46));
            }
            this.cur.addBound(string);
        }
        return null;
    }

    @Override
    public Object visitImportFrom(ImportFrom importFrom) throws Exception {
        Future.checkFromFuture(importFrom);
        int n = importFrom.getInternalNames().size();
        if (n == 0) {
            this.cur.from_import_star = true;
            return null;
        }
        for (int i = 0; i < n; ++i) {
            if (importFrom.getInternalNames().get(i).getInternalAsname() != null) {
                this.cur.addBound(importFrom.getInternalNames().get(i).getInternalAsname());
                continue;
            }
            this.cur.addBound(importFrom.getInternalNames().get(i).getInternalName());
        }
        return null;
    }

    @Override
    public Object visitGlobal(Global global) throws Exception {
        int n = global.getInternalNames().size();
        for (int i = 0; i < n; ++i) {
            String string = global.getInternalNames().get(i);
            int n2 = this.cur.addGlobal(string);
            if (n2 < 0) continue;
            if ((n2 & 8) != 0) {
                this.code_compiler.error("name '" + string + "' is local and global", true, global);
            }
            if ((n2 & 0x42) != 0) continue;
            String string2 = (n2 & 1) != 0 ? "assignment" : "use";
            this.code_compiler.error("name '" + string + "' declared global after " + string2, false, global);
        }
        return null;
    }

    @Override
    public Object visitExec(Exec exec) throws Exception {
        this.cur.exec = true;
        if (exec.getInternalGlobals() == null && exec.getInternalLocals() == null) {
            this.cur.unqual_exec = true;
        }
        this.traverse(exec);
        return null;
    }

    @Override
    public Object visitClassDef(ClassDef classDef) throws Exception {
        this.def(classDef.getInternalName());
        int n = classDef.getInternalBases().size();
        for (int i = 0; i < n; ++i) {
            this.visit(classDef.getInternalBases().get(i));
        }
        this.beginScope(classDef.getInternalName(), 2, classDef, null);
        this.suite(classDef.getInternalBody());
        this.endScope();
        return null;
    }

    @Override
    public Object visitName(Name name) throws Exception {
        String string = name.getInternalId();
        if (name.getInternalCtx() != expr_contextType.Load) {
            if (string.equals("__debug__")) {
                this.code_compiler.error("can not assign to __debug__", true, name);
            }
            this.cur.addBound(string);
        } else {
            this.cur.addUsed(string);
        }
        return null;
    }

    @Override
    public Object visitListComp(ListComp listComp) throws Exception {
        String string = "_[" + listComp.getLine() + "_" + listComp.getCharPositionInLine() + "]";
        this.cur.addBound(string);
        this.traverse(listComp);
        return null;
    }

    @Override
    public Object visitYield(Yield yield) throws Exception {
        this.cur.defineAsGenerator(yield);
        ++this.cur.yield_count;
        this.traverse(yield);
        return null;
    }

    @Override
    public Object visitReturn(Return return_) throws Exception {
        if (return_.getInternalValue() != null) {
            this.cur.noteReturnValue(return_);
        }
        this.traverse(return_);
        return null;
    }

    @Override
    public Object visitGeneratorExp(GeneratorExp generatorExp) throws Exception {
        if (generatorExp.getInternalGenerators() != null && generatorExp.getInternalGenerators().size() > 0) {
            this.visit(generatorExp.getInternalGenerators().get(0).getInternalIter());
        }
        String string = "_(x)";
        String string2 = "_(" + generatorExp.getLine() + "_" + generatorExp.getCharPositionInLine() + ")";
        this.def(string2);
        ArgListCompiler argListCompiler = new ArgListCompiler();
        ArrayList<expr> arrayList = new ArrayList<expr>();
        arrayList.add(new Name(generatorExp.getToken(), string, expr_contextType.Param));
        argListCompiler.visitArgs(new arguments(generatorExp, arrayList, null, null, new ArrayList<expr>()));
        this.beginScope(string2, 1, generatorExp, argListCompiler);
        this.cur.addParam(string);
        this.cur.markFromParam();
        this.cur.defineAsGenerator(generatorExp);
        ++this.cur.yield_count;
        if (generatorExp.getInternalElt() != null) {
            this.visit(generatorExp.getInternalElt());
        }
        if (generatorExp.getInternalGenerators() != null) {
            for (int i = 0; i < generatorExp.getInternalGenerators().size(); ++i) {
                if (generatorExp.getInternalGenerators().get(i) == null) continue;
                if (i == 0) {
                    this.visit(generatorExp.getInternalGenerators().get(i).getInternalTarget());
                    if (generatorExp.getInternalGenerators().get(i).getInternalIfs() == null) continue;
                    for (expr expr2 : generatorExp.getInternalGenerators().get(i).getInternalIfs()) {
                        if (expr2 == null) continue;
                        this.visit(expr2);
                    }
                    continue;
                }
                this.visit(generatorExp.getInternalGenerators().get(i));
            }
        }
        this.endScope();
        return null;
    }

    @Override
    public Object visitWith(With with) throws Exception {
        ++this.cur.max_with_count;
        this.traverse(with);
        return null;
    }
}

